//
//  MCDatabaseComboBoxController.h
//  MCApplication
//
//  Created by Alykhan Jetha on Sat May 31 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPEntity, MCPAttribute, MCPDatabaseConnection, BDQualifier;

// User Defaults for large databases
#define MCDatabaseComboMinimumCompletionKeystokeLength	@"MCDatabaseComboMinimumCompletionKeystokeLength"

/*!
	@class MCDatabaseComboBoxController
	@discussion 
	
	
	Working with strings

	[countryCBC setUsesStrings:YES];
	[countryCBC setEntity:geo];
	[countryCBC setMatchAttribute:[geo attributeForName:@"country"]];
	[countryCBC setDatabaseConnection:[[self document] databaseConnection]];


	Working with raw rows
	
	[postalCBC setEntity:geo];
	[postalCBC setMatchAttribute:[geo attributeForName:@"postalCode"]];
	[postalCBC setSelectAttributes:[NSArray arrayWithObjects:[geo attributeForName:@"gAddressID"], [geo attributeForName:@"postalCode"], [geo attributeForName:@"city"], [geo attributeForName:@"state"], [geo attributeForName:@"country"], nil]];	
	[postalCBC setDatabaseConnection:[[self document] databaseConnection]];
	
	
	
	Working with TableView cells
	
		- (void)tvc:aTVC 
			willDisplayCell:(id)aCell 
			forColumn:(NSTableColumn *)tc 
			item:(id)object;
		{
			if (tc == zipColumn){
				
				[aCell setBordered:NO];
				[aCell setDelegate:tableZIPCBC];
			
				[aCell setUsesDataSource:YES];
				[aCell setDataSource:tableZIPCBC];
				[aCell setCompletes:YES];
				
			}
		}


*/

@interface MCDatabaseComboBoxController : NSObject {
	id						comboBox; 		// not retained

	MCPEntity				*entity;		// not retained
	NSArray					*selectAttributes;
	MCPAttribute			*matchAttribute; // not retained
	MCPDatabaseConnection	*databaseConnection; // not retained

	BOOL					usesStrings;
	BOOL 					matchFoundForLastString;

	NSArray					*defaultStrings;
	
	NSArray					*currentMatches;
	int						lastStringLength;
	int						minimumLengthBeforeQualify;
	
	id						(matchedObject);

	id						delegate;		// not retained
	
	
	NSString				*entityName, *matchAttributeName, *selectAttributeNames;
	NSString				*databaseConnectionSelectorName, *combinedDefaultStrings; 

}


- (void)setEntityName:(NSString *)aName;
- (NSString *)entityName; 

- (void)setMatchAttributeName:(NSString *)aName;
- (NSString *)matchAttributeName;

- (void)setSelectAttributeNames:(NSString *)aName;
- (NSString *)selectAttributeNames;

- (void)setCombinedDefaultStrings:(NSString *)aName;
- (NSString *)combinedDefaultStrings;

- (void)setDatabaseConnectionSelectorName:(NSString *)aName;
- (NSString *)databaseConnectionSelectorName;

- (void)setComboBox:(id)cb;
- (id)comboBox;

- (void)setDelegate:(id)deleg;
- (id)delegate;

- (void)setUsesStrings:(BOOL)flag;
- (BOOL)usesStrings;

- (void)setEntity:(MCPEntity *)ent;
- (MCPEntity *)entity;

- (void)setSelectAttributes:(NSArray *)attribs;
- (NSArray *)selectAttributes;

- (void)setMatchAttribute:(MCPAttribute *)attrib;
- (MCPAttribute *)matchAttribute;

- (void)setDefaultStrings:(NSArray *)strings;
- (NSArray *)defaultStrings;

- (void)setDatabaseConnection:(MCPDatabaseConnection *)conn;
- (MCPDatabaseConnection *)databaseConnection;

- (void)setCurrentMatches:(NSArray *)array;
- (NSArray *)currentMatches;

- (void)setCurrentMatch:(id)match;
- (id)currentMatch;

- (void)registerForComboBoxNotifications;
- (void)configureFromNames;

- (void)setMutable:(BOOL)flag;
- (void)setEnabled:(BOOL)flag;

- (void)databaseConnectionDidChange:(NSNotification *)notification;
- (void)deriveDatabaseConnection;
@end


@interface NSObject (MCComboBoxDelegate)
- (void)comboBoxController:(id)cbc didMatchObject:(id)obj;
@end

